/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.screen.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.common.perk.Perk;
import dev.toma.gunsrpg.common.perk.PerkType;
import dev.toma.gunsrpg.util.ITickable;
import dev.toma.gunsrpg.util.ModUtils;
import dev.toma.gunsrpg.util.RenderUtils;
import java.text.DecimalFormat;
import lib.toma.animations.AnimationUtils;
import lib.toma.animations.Easings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;

public class PerkWidget
extends Widget
implements ITickable {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.00", ModUtils.DOT_DECIMAL_SEPARATOR);
    private final FontRenderer font;
    private final Perk perk;
    private final ResourceLocation icon;
    private final State state;
    private final float value;
    private final boolean maxLevel;
    private int loadTimer = 40;
    private int prevLoadTimer;

    public PerkWidget(int x, int y, int width, int height, FontRenderer renderer, Perk perk, float value, State state) {
        super(x, y, width, height, perk.getDisplayName());
        this.perk = perk;
        this.font = renderer;
        this.value = value;
        this.state = state;
        ResourceLocation perkId = perk.getPerkId();
        this.icon = new ResourceLocation(perkId.func_110624_b(), "textures/icons/perk/" + perkId.func_110623_a() + ".png");
        this.maxLevel = ModUtils.equals(perk.getBounds(state == State.DEBUFF ? PerkType.DEBUFF : PerkType.BUFF), Math.abs(value), 0.001);
    }

    @Override
    public void tick() {
        if (this.state == State.NULLIFIED || this.state == State.NONE) {
            return;
        }
        this.prevLoadTimer = this.loadTimer;
        if (this.loadTimer > 0) {
            --this.loadTimer;
        }
    }

    public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        int bgColor = this.state.bgColor | 0xFF000000;
        int bgColorSecondary = RenderUtils.darken(bgColor, 0.6f) | 0xFF000000;
        int borderColor = this.maxLevel ? 16756224 : 0;
        float interpolatedLoadTimer = AnimationUtils.linearInterpolate(this.loadTimer, this.prevLoadTimer, partialTicks);
        float numberProgress = 1.0f - interpolatedLoadTimer / 40.0f;
        float value = Easings.EASE_OUT_EXP.ease(numberProgress) * this.value;
        Matrix4f pose = matrix.func_227866_c_().func_227870_a_();
        RenderUtils.drawSolid(pose, this.field_230690_l_, this.field_230691_m_, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + this.field_230689_k_, 0xFF000000 | borderColor);
        RenderUtils.drawGradient(pose, this.field_230690_l_ + 1, this.field_230691_m_ + 1, this.field_230690_l_ + this.field_230688_j_ - 1, this.field_230691_m_ + this.field_230689_k_ - 1, bgColor, bgColorSecondary);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.icon);
        RenderUtils.drawTex(pose, this.field_230690_l_ + 2, this.field_230691_m_ + 2, this.field_230690_l_ + 18, this.field_230691_m_ + 18);
        String text = FORMAT.format(Math.abs(value) * 100.0f) + "%";
        if (this.maxLevel) {
            text = TextFormatting.BOLD + text;
        }
        int width = this.font.func_78256_a(text);
        float f = this.field_230690_l_ + this.field_230688_j_ - 2 - width;
        float f2 = this.field_230691_m_;
        this.font.getClass();
        this.font.func_238405_a_(matrix, text, f, f2 + (float)(this.field_230689_k_ - 9) / 2.0f, 0xCCCCCC);
        if (this.field_230692_n_) {
            ITextComponent name = this.func_230458_i_();
            int nameWidth = this.font.func_238414_a_((ITextProperties)name);
            this.font.func_243246_a(matrix, name, (float)this.field_230690_l_ + (float)(this.field_230688_j_ - nameWidth) / 2.0f, (float)(this.field_230691_m_ + this.field_230689_k_ + 2), 0xFFFFFF);
        }
    }

    public static enum State {
        BUFF(39168),
        DEBUFF(0x990000),
        NULLIFIED(0x999900),
        NONE(0x666666);

        private final int bgColor;

        private State(int bgColor) {
            this.bgColor = bgColor;
        }
    }
}

